
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="chili_plants", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="potato_vines", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="pansies", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="basil_plants", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(6 * x0 + 3 * x1 + 6 * x2 + 5 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(20 * x0 + 4 * x1 + 20 * x2 + 2 * x3 >= 2304)
    model.addConstr(20 * x0 + 4 * x1 >= 5328)
    model.addConstr(20 * x0 + 2 * x3 >= 2448)
    model.addConstr(20 * x2 + 2 * x3 >= 2304)
    model.addConstr(18 * x0 + 7 * x1 + 17 * x2 + 14 * x3 >= 298)
    model.addConstr(18 * x0 + 17 * x2 >= 65)
    model.addConstr(18 * x0 + 14 * x3 >= 63)
    model.addConstr(18 * x0 + 7 * x1 + 17 * x2 >= 53)
    model.addConstr(7 * x1 + 17 * x2 + 14 * x3 >= 53)
    model.addConstr(18 * x0 + 7 * x1 + 17 * x2 >= 61)
    model.addConstr(7 * x1 + 17 * x2 + 14 * x3 >= 61)
    model.addConstr(18 * x0 + 7 * x1 + 17 * x2 + 14 * x3 >= 61)
    model.addConstr(-10 * x0 + 9 * x1 >= 0)
    model.addConstr(3 * x1 - 10 * x2 >= 0)
    model.addConstr(7 * x1 + 14 * x3 <= 168)
    model.addConstr(17 * x2 + 14 * x3 <= 230)
    model.addConstr(18 * x0 + 17 * x2 + 14 * x3 <= 120)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Chili plants: ", x0.varValue)
        print("Potato vines: ", x1.varValue)
        print("Pansies: ", x2.varValue)
        print("Basil plants: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
