
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams of potassium")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams of vitamin E")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="grams of carbohydrates")


    # Set objective function
    m.setObjective(7*x0 + 4*x1 + x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(9*x0 + 3*x1 >= 40, "c1")
    m.addConstr(3*x1 + 5*x2 >= 27, "c2")
    m.addConstr(9*x0 + 5*x2 >= 25, "c3")
    m.addConstr(9*x0 + 3*x1 + 5*x2 >= 25, "c4")
    m.addConstr(15*x1 + 13*x2 >= 50, "c5")
    m.addConstr(14*x0 + 15*x1 >= 51, "c6")
    m.addConstr(14*x0 + 15*x1 + 13*x2 >= 50, "c7")
    m.addConstr(14*x0 + 15*x1 + 13*x2 >= 50, "c8") # Redundant constraint
    m.addConstr(10*x0 - 7*x1 >= 0, "c9")
    m.addConstr(-3*x1 + 9*x2 >= 0, "c10")
    m.addConstr(9*x0 + 3*x1 <= 65, "c11")
    m.addConstr(9*x0 + 5*x2 <= 73, "c12")
    m.addConstr(9*x0 + 3*x1 + 5*x2 <= 55, "c13")
    m.addConstr(14*x0 + 15*x1 + 13*x2 <= 87, "c14")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

