
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of potassium
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin E
    x2 = model.addVar(name="x2", lb=0)  # grams of carbohydrates

    # Define the objective function
    model.setObjective(7 * x0 + 4 * x1 + x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * x0 <= 121)
    model.addConstr(14 * x0 <= 169)
    model.addConstr(3 * x1 <= 121)
    model.addConstr(15 * x1 <= 169)
    model.addConstr(5 * x2 <= 121)
    model.addConstr(13 * x2 <= 169)
    model.addConstr(9 * x0 + 3 * x1 >= 40)
    model.addConstr(3 * x1 + 5 * x2 >= 27)
    model.addConstr(9 * x0 + 5 * x2 >= 25)
    model.addConstr(9 * x0 + 3 * x1 + 5 * x2 >= 25)
    model.addConstr(15 * x1 + 13 * x2 >= 50)
    model.addConstr(14 * x0 + 15 * x1 >= 51)
    model.addConstr(14 * x0 + 15 * x1 + 13 * x2 >= 50)
    model.addConstr(10 * x0 - 7 * x1 >= 0)
    model.addConstr(-3 * x1 + 9 * x2 >= 0)
    model.addConstr(9 * x0 + 3 * x1 <= 65)
    model.addConstr(9 * x0 + 5 * x2 <= 73)
    model.addConstr(9 * x0 + 3 * x1 + 5 * x2 <= 55)
    model.addConstr(14 * x0 + 15 * x1 + 13 * x2 <= 87)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of potassium: {x0.varValue}")
        print(f"Milligrams of vitamin E: {x1.varValue}")
        print(f"Grams of carbohydrates: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
