
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(name="hours_worked_by_George")
    x1 = m.addVar(name="hours_worked_by_Bill")
    x2 = m.addVar(name="hours_worked_by_Peggy")
    x3 = m.addVar(name="hours_worked_by_Ringo")


    # Set objective function
    m.setObjective(1.9 * x0 + 2.09 * x1 + 5.6 * x2 + 2.2 * x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4 * x1 + 2 * x3 >= 13)
    m.addConstr(4 * x1 + 11 * x2 + 2 * x3 >= 15)
    m.addConstr(7 * x0 + 11 * x2 + 2 * x3 >= 15)
    m.addConstr(7 * x0 + 4 * x1 + 11 * x2 >= 15)
    m.addConstr(4 * x1 + 11 * x2 + 2 * x3 >= 21)
    m.addConstr(7 * x0 + 11 * x2 + 2 * x3 >= 21)
    m.addConstr(7 * x0 + 4 * x1 + 11 * x2 >= 21)
    m.addConstr(4 * x1 + 11 * x2 + 2 * x3 >= 17)
    m.addConstr(7 * x0 + 11 * x2 + 2 * x3 >= 17)
    m.addConstr(7 * x0 + 4 * x1 + 11 * x2 >= 17)
    m.addConstr(3 * x1 + 6 * x2 + 8 * x3 >= 19)
    m.addConstr(4 * x1 + 11 * x2 <= 92)
    m.addConstr(7 * x0 + 11 * x2 <= 58)
    m.addConstr(11 * x2 + 2 * x3 <= 84)
    m.addConstr(7 * x0 + 4 * x1 + 11 * x2 <= 54)
    m.addConstr(7 * x0 + 4 * x1 + 11 * x2 + 2 * x3 <= 54)
    m.addConstr(3 * x1 + 6 * x2 <= 27)
    m.addConstr(3 * x1 + 8 * x3 <= 73)
    m.addConstr(8 * x0 + 8 * x3 <= 37)
    m.addConstr(6 * x2 + 8 * x3 <= 73)
    m.addConstr(8 * x0 + 3 * x1 + 6 * x2 + 8 * x3 <= 73)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
