
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by George
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bill
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Peggy
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Ringo

    # Define the objective function
    model.setObjective(1.9*x0 + 2.09*x1 + 5.6*x2 + 2.2*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4*x1 + 2*x3 >= 13)
    model.addConstr(4*x1 + 11*x2 + 2*x3 >= 15)
    model.addConstr(7*x0 + 11*x2 + 2*x3 >= 15)
    model.addConstr(7*x0 + 4*x1 + 11*x2 >= 15)
    model.addConstr(4*x1 + 11*x2 + 2*x3 >= 21)
    model.addConstr(7*x0 + 11*x2 + 2*x3 >= 21)
    model.addConstr(7*x0 + 4*x1 + 11*x2 >= 21)
    model.addConstr(4*x1 + 11*x2 + 2*x3 >= 17)
    model.addConstr(7*x0 + 11*x2 + 2*x3 >= 17)
    model.addConstr(7*x0 + 4*x1 + 11*x2 >= 17)
    model.addConstr(3*x1 + 6*x2 + 8*x3 >= 19)
    model.addConstr(4*x1 + 11*x2 <= 92)
    model.addConstr(7*x0 + 11*x2 <= 58)
    model.addConstr(11*x2 + 2*x3 <= 84)
    model.addConstr(7*x0 + 4*x1 + 11*x2 <= 54)
    model.addConstr(7*x0 + 4*x1 + 11*x2 + 2*x3 <= 54)
    model.addConstr(3*x1 + 6*x2 <= 27)
    model.addConstr(3*x1 + 8*x3 <= 73)
    model.addConstr(8*x0 + 8*x3 <= 37)
    model.addConstr(6*x2 + 8*x3 <= 73)
    model.addConstr(8*x0 + 3*x1 + 6*x2 + 8*x3 <= 73)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by George: ", x0.varValue)
        print("Hours worked by Bill: ", x1.varValue)
        print("Hours worked by Peggy: ", x2.varValue)
        print("Hours worked by Ringo: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
