
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="military_intelligence_companies")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="transportation_companies")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="water_purification_units")


    # Set objective function
    m.setObjective(3.34 * x0 + 7.58 * x1 + 8.16 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(0.9 * x0 + 5.21 * x2 >= 31, "c1")
    m.addConstr(0.9 * x0 + 2.23 * x1 >= 23, "c2")
    m.addConstr(2.23 * x1 + 5.21 * x2 >= 37, "c3")
    m.addConstr(0.9 * x0 + 2.23 * x1 + 5.21 * x2 >= 37, "c4")
    m.addConstr(3.14 * x0 + 1.42 * x1 >= 28, "c5")
    m.addConstr(3.14 * x0 + 3.04 * x2 >= 20, "c6")
    m.addConstr(1.42 * x1 + 3.04 * x2 >= 29, "c7")
    m.addConstr(3.14 * x0 + 1.42 * x1 + 3.04 * x2 >= 29, "c8")
    m.addConstr(3.14 * x0 + 1.42 * x1 <= 45, "c9")

    # Add upper bound constraints based on resource limits
    m.addConstr(x0 <= 139, "c10")
    m.addConstr(x1 <= 127, "c11")
    m.addConstr(x2 <= 127, "c12")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
