
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='military_intelligence_companies', vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name='transportation_companies', vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name='water_purification_units', vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(3.34*x0 + 7.58*x1 + 8.16*x2, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(0.9*x0 + 5.21*x2 >= 31, name='offensive_capability_rating_1')
model.addConstr(0.9*x0 + 2.23*x1 >= 23, name='offensive_capability_rating_2')
model.addConstr(2.23*x1 + 5.21*x2 >= 37, name='offensive_capability_rating_3')
model.addConstr(0.9*x0 + 2.23*x1 + 5.21*x2 >= 37, name='offensive_capability_rating_4')
model.addConstr(3.14*x0 + 1.42*x1 >= 28, name='deployment_weight_1')
model.addConstr(3.14*x0 + 3.04*x2 >= 20, name='deployment_weight_2')
model.addConstr(1.42*x1 + 3.04*x2 >= 29, name='deployment_weight_3')
model.addConstr(3.14*x0 + 1.42*x1 + 3.04*x2 >= 29, name='deployment_weight_4')
model.addConstr(3.14*x0 + 1.42*x1 <= 45, name='deployment_weight_5')

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Military intelligence companies: ', x0.varValue)
    print('Transportation companies: ', x1.varValue)
    print('Water purification units: ', x2.varValue)
else:
    print('The model is infeasible')
