
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
hank = m.addVar(vtype=gp.GRB.INTEGER, name="hank")
bobby = m.addVar(vtype=gp.GRB.INTEGER, name="bobby")
laura = m.addVar(vtype=gp.GRB.INTEGER, name="laura")
paul = m.addVar(vtype=gp.GRB.INTEGER, name="paul")
peggy = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy")

# Set objective function
m.setObjective(2.55 * hank + 7.28 * bobby + 5.19 * laura + 8.05 * paul + 9.52 * peggy, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(25 * laura + 8 * paul >= 59)
m.addConstr(30 * hank + 25 * laura >= 92)
m.addConstr(14 * bobby + 25 * laura >= 57)
m.addConstr(14 * bobby + 14 * peggy >= 54)
m.addConstr(14 * bobby + 8 * paul >= 74)
m.addConstr(30 * hank + 14 * bobby + 8 * paul >= 58)
m.addConstr(14 * bobby + 25 * laura + 14 * peggy >= 58)
m.addConstr(30 * hank + 14 * bobby + 8 * paul >= 51)
m.addConstr(14 * bobby + 25 * laura + 14 * peggy >= 51)
m.addConstr(20 * laura + 24 * paul + 9 * peggy >= 25)
m.addConstr(18 * bobby + 20 * laura + 24 * paul >= 25)
m.addConstr(20 * laura + 24 * paul + 9 * peggy >= 29)
m.addConstr(18 * bobby + 20 * laura + 24 * paul >= 29)
m.addConstr(30 * hank + 14 * peggy <= 118)
m.addConstr(30 * hank + 25 * laura <= 230)
m.addConstr(14 * bobby + 14 * peggy <= 111)
m.addConstr(25 * laura + 14 * peggy <= 201)
m.addConstr(30 * hank + 8 * paul <= 444)
m.addConstr(30 * hank + 14 * bobby + 25 * laura + 8 * paul + 14 * peggy <= 444)
m.addConstr(24 * paul + 9 * peggy <= 128)
m.addConstr(3 * hank + 9 * peggy <= 76)
m.addConstr(3 * hank + 24 * paul <= 110)
m.addConstr(3 * hank + 18 * bobby <= 47)
m.addConstr(3 * hank + 20 * laura <= 137)
m.addConstr(3 * hank + 18 * bobby + 20 * laura <= 97)
m.addConstr(18 * bobby + 20 * laura + 9 * peggy <= 162)
m.addConstr(3 * hank + 24 * paul + 9 * peggy <= 47)
m.addConstr(3 * hank + 18 * bobby + 24 * paul <= 201)
m.addConstr(3 * hank + 20 * laura + 9 * peggy <= 181)
m.addConstr(18 * bobby + 20 * laura + 24 * paul <= 103)
m.addConstr(3 * hank + 18 * bobby + 20 * laura + 24 * paul + 9 * peggy <= 103)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

