
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='x0', vtype='I')  # hours worked by Hank
x1 = m.addVar(name='x1', vtype='I')  # hours worked by Bobby
x2 = m.addVar(name='x2', vtype='I')  # hours worked by Laura
x3 = m.addVar(name='x3', vtype='I')  # hours worked by Paul
x4 = m.addVar(name='x4')  # hours worked by Peggy

# Objective function
m.setObjective(2.55*x0 + 7.28*x1 + 5.19*x2 + 8.05*x3 + 9.52*x4, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(30*x0 <= 482)
m.addConstr(3*x0 <= 202)
m.addConstr(14*x1 <= 482)
m.addConstr(18*x1 <= 202)
m.addConstr(25*x2 <= 482)
m.addConstr(20*x2 <= 202)
m.addConstr(8*x3 <= 482)
m.addConstr(24*x3 <= 202)
m.addConstr(14*x4 <= 482)
m.addConstr(9*x4 <= 202)
m.addConstr(25*x2 + 8*x3 >= 59)
m.addConstr(30*x0 + 25*x2 >= 92)
m.addConstr(14*x1 + 25*x2 >= 57)
m.addConstr(14*x1 + 14*x4 >= 54)
m.addConstr(14*x1 + 8*x3 >= 74)
m.addConstr(30*x0 + 14*x1 + 8*x3 >= 58)
m.addConstr(14*x1 + 25*x2 + 14*x4 >= 58)
m.addConstr(30*x0 + 14*x1 + 8*x3 >= 51)
m.addConstr(14*x1 + 25*x2 + 14*x4 >= 51)
m.addConstr(20*x2 + 24*x3 + 9*x4 >= 25)
m.addConstr(18*x1 + 20*x2 + 24*x3 >= 25)
m.addConstr(20*x2 + 24*x3 + 9*x4 >= 29)
m.addConstr(18*x1 + 20*x2 + 24*x3 >= 29)
m.addConstr(30*x0 + 14*x4 <= 118)
m.addConstr(30*x0 + 25*x2 <= 230)
m.addConstr(14*x1 + 14*x4 <= 111)
m.addConstr(25*x2 + 14*x4 <= 201)
m.addConstr(30*x0 + 8*x3 <= 444)
m.addConstr(30*x0 + 14*x1 + 25*x2 + 8*x3 + 14*x4 <= 444)
m.addConstr(24*x3 + 9*x4 <= 128)
m.addConstr(3*x0 + 9*x4 <= 76)
m.addConstr(3*x0 + 24*x3 <= 110)
m.addConstr(3*x0 + 18*x1 <= 47)
m.addConstr(3*x0 + 20*x2 <= 137)
m.addConstr(3*x0 + 18*x1 + 20*x2 <= 97)
m.addConstr(18*x1 + 20*x2 + 9*x4 <= 162)
m.addConstr(3*x0 + 24*x3 + 9*x4 <= 47)
m.addConstr(3*x0 + 18*x1 + 24*x3 <= 201)
m.addConstr(3*x0 + 20*x2 + 9*x4 <= 181)
m.addConstr(18*x1 + 20*x2 + 24*x3 <= 103)
m.addConstr(3*x0 + 18*x1 + 20*x2 + 24*x3 + 9*x4 <= 103)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objval)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
    print('x4: ', x4.varValue)
else:
    print('No optimal solution found')
