
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    hank = model.addVar(vtype=gp.GRB.INTEGER, name="hank")
    bobby = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bobby")
    ringo = model.addVar(vtype=gp.GRB.CONTINUOUS, name="ringo")

    # Set objective function
    model.setObjective(4 * hank + 3 * bobby + 1 * ringo, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(11 * hank + 22 * ringo >= 38)
    model.addConstr(11 * hank + 7 * bobby >= 67)
    model.addConstr(11 * hank + 7 * bobby + 22 * ringo >= 67)
    model.addConstr(18 * bobby + 5 * ringo >= 90)
    model.addConstr(20 * hank + 18 * bobby >= 69)
    model.addConstr(20 * hank + 18 * bobby + 5 * ringo >= 69)
    model.addConstr(13 * hank + 9 * ringo >= 58)
    model.addConstr(13 * hank + 16 * bobby >= 25)
    model.addConstr(13 * hank + 16 * bobby + 9 * ringo >= 25)
    model.addConstr(20 * hank + 5 * bobby >= 44)
    model.addConstr(20 * hank + 1 * ringo >= 27)
    model.addConstr(5 * bobby + 1 * ringo >= 45)
    model.addConstr(20 * hank + 5 * bobby + 1 * ringo >= 45)
    model.addConstr(10 * hank - 10 * ringo >= 0)
    model.addConstr(11 * hank + 22 * ringo <= 242)
    model.addConstr(7 * bobby + 22 * ringo <= 96)
    model.addConstr(20 * hank + 18 * bobby + 5 * ringo <= 278)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('hank:', hank.x)
        print('bobby:', bobby.x)
        print('ringo:', ringo.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
