
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Hank
    x1 = model.addVar(name="x1")  # hours worked by Bobby
    x2 = model.addVar(name="x2")  # hours worked by Ringo

    # Objective function
    model.setObjective(4 * x0 + 3 * x1 + x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(11 * x0 <= 263)
    model.addConstr(20 * x0 <= 345)
    model.addConstr(13 * x0 <= 215)
    model.addConstr(20 * x0 <= 197)

    model.addConstr(7 * x1 <= 263)
    model.addConstr(18 * x1 <= 345)
    model.addConstr(16 * x1 <= 215)
    model.addConstr(5 * x1 <= 197)

    model.addConstr(22 * x2 <= 263)
    model.addConstr(5 * x2 <= 345)
    model.addConstr(9 * x2 <= 215)
    model.addConstr(x2 <= 197)

    model.addConstr(11 * x0 + 22 * x2 >= 38)
    model.addConstr(11 * x0 + 7 * x1 >= 67)
    model.addConstr(11 * x0 + 7 * x1 + 22 * x2 >= 67)

    model.addConstr(18 * x1 + 5 * x2 >= 90)
    model.addConstr(20 * x0 + 18 * x1 >= 69)
    model.addConstr(20 * x0 + 18 * x1 + 5 * x2 >= 69)

    model.addConstr(13 * x0 + 9 * x2 >= 58)
    model.addConstr(13 * x0 + 16 * x1 >= 25)
    model.addConstr(13 * x0 + 16 * x1 + 9 * x2 >= 25)

    model.addConstr(20 * x0 + 5 * x1 >= 44)
    model.addConstr(20 * x0 + x2 >= 27)
    model.addConstr(5 * x1 + x2 >= 45)

    model.addConstr(20 * x0 + 5 * x1 + x2 >= 45)
    model.addConstr(10 * x0 - 10 * x2 >= 0)

    model.addConstr(11 * x0 + 22 * x2 <= 242)
    model.addConstr(7 * x1 + 22 * x2 <= 96)
    model.addConstr(20 * x0 + 18 * x1 + 5 * x2 <= 278)

    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Hank: {x0.varValue}")
        print(f"Hours worked by Bobby: {x1.varValue}")
        print(f"Hours worked by Ringo: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
