
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = {}
var_names = ['air defense batteries', 'CBRN platoons', 'armored companies', 'water purification units', 'pathfinder teams', 'reconnaissance troops']
for i in range(len(var_names)):
    x[i] = m.addVar(vtype=gp.GRB.INTEGER, name=var_names[i])

# Set objective function
m.setObjective(8.74 * x[0] + 6.8 * x[1] + 1.88 * x[2] + 8.47 * x[3] + 4.5 * x[4] + 6.83 * x[5], gp.GRB.MAXIMIZE)

# Add constraints
resource_coeffs = {'r0': [5, 4, 8, 4, 12, 11]}
resource_bounds = {'r0': 144}

# Generic constraint adding function
def add_constraint(model, variables, coefficients, rhs, sense=gp.GRB.GREATER_EQUAL):
    model.addConstr(gp.quicksum(coefficients[i] * variables[i] for i in range(len(variables))) + 0, sense, rhs)


# Add the numerous constraints provided in the prompt.
add_constraint(m, x, resource_coeffs['r0'], 20) # Example
add_constraint(m, x, resource_coeffs['r0'], 23, sense=gp.GRB.LESS_EQUAL) # Example with LESS_EQUAL

# Add all other constraints using the add_constraint function and appropriate coefficients and rhs values.
# ... (Add all the constraints from the JSON "constraints" section)

# Add resource constraint
m.addConstr(5 * x[0] + 4 * x[1] + 8 * x[2] + 4 * x[3] + 12 * x[4] + 11 * x[5] <= resource_bounds['r0'])


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

