
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='air defense batteries', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='CBRN platoons', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='armored companies', vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name='water purification units', vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(name='pathfinder teams', vtype=gurobi.GRB.INTEGER)
    x6 = model.addVar(name='reconnaissance troops', vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8.74*x1 + 6.8*x2 + 1.88*x3 + 8.47*x4 + 4.5*x5 + 6.83*x6, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x1 + 8*x3 + 11*x6 >= 23)
    model.addConstr(4*x2 + 4*x4 + 11*x6 >= 23)
    model.addConstr(4*x4 + 12*x5 + 11*x6 >= 23)
    model.addConstr(4*x2 + 12*x5 + 11*x6 >= 23)
    model.addConstr(5*x1 + 8*x3 + 11*x6 >= 23)
    model.addConstr(5*x1 + 12*x5 + 11*x6 >= 23)
    model.addConstr(4*x2 + 8*x3 + 12*x5 >= 23)
    model.addConstr(5*x1 + 4*x2 + 11*x6 >= 23)
    model.addConstr(5*x1 + 8*x3 + 4*x4 >= 23)
    model.addConstr(5*x1 + 4*x4 + 12*x5 >= 23)
    model.addConstr(4*x2 + 4*x4 + 12*x5 >= 23)
    model.addConstr(8*x3 + 4*x4 <= 137)
    model.addConstr(5*x1 + 11*x6 <= 110)
    model.addConstr(12*x4 + 12*x5 <= 25)
    model.addConstr(8*x3 + 4*x2 <= 117)
    model.addConstr(8*x3 + 11*x6 <= 38)
    model.addConstr(4*x2 + 5*x1 <= 112)
    model.addConstr(8*x3 + 12*x5 <= 74)
    model.addConstr(4*x4 + 11*x6 <= 32)
    model.addConstr(5*x1 + 12*x5 <= 31)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print('Optimal solution found.')
        print(f'Air defense batteries: {x1.varValue}')
        print(f'CBRN platoons: {x2.varValue}')
        print(f'Armored companies: {x3.varValue}')
        print(f'Water purification units: {x4.varValue}')
        print(f'Pathfinder teams: {x5.varValue}')
        print(f'Reconnaissance troops: {x6.varValue}')
        print(f'Objective: {model.objVal}')
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print('No feasible solution exists.')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
