
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milkshakes")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")

# Set the objective function
m.setObjective(1.66*x1 + 8.63*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8.76*x1 + 11.41*x2 >= 36, "Total_protein_minimum")
m.addConstr(x1 - 9*x2 >= 0, "Milkshakes_vs_PeanutButterSandwiches")
m.addConstr(8.76*x1 + 11.41*x2 <= 58, "Total_protein_maximum")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")
