
import gurobipy as gp

# Create a new model
model = gp.Model("Optimization_Problem")

# Define the variables
milkshakes = model.addVar(name="milkshakes", lb=0)  # Assuming non-negative
peanutbutter_sandwiches = model.addVar(name="peanutbutter_sandwiches", lb=0)  # Assuming non-negative

# Define the objective function
model.setObjective(1.66 * milkshakes + 8.63 * peanutbutter_sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(8.76 * milkshakes + 11.41 * peanutbutter_sandwiches >= 36)
model.addConstr(milkshakes - 9 * peanutbutter_sandwiches >= 0)
model.addConstr(8.76 * milkshakes + 11.41 * peanutbutter_sandwiches <= 58)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milkshakes: {milkshakes.varValue}")
    print(f"Peanutbutter Sandwiches: {peanutbutter_sandwiches.varValue}")
    print(f"Objective Function Value: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
