
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    bobby_hours = model.addVar(vtype=gp.GRB.INTEGER, name="bobby_hours")
    paul_hours = model.addVar(vtype=gp.GRB.INTEGER, name="paul_hours")
    ringo_hours = model.addVar(vtype=gp.GRB.INTEGER, name="ringo_hours")

    # Set objective function
    model.setObjective(4 * bobby_hours + 5 * paul_hours + 3 * ringo_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5 * bobby_hours + 7 * ringo_hours >= 16, "dollar_cost_bobby_ringo")
    model.addConstr(9 * paul_hours + 5 * ringo_hours >= 18, "quit_index_paul_ringo")
    model.addConstr(4 * bobby_hours + 9 * paul_hours >= 12, "quit_index_bobby_paul")
    model.addConstr(4 * bobby_hours + 9 * paul_hours + 5 * ringo_hours >= 15, "quit_index_all")
    model.addConstr(5 * bobby_hours + 1 * paul_hours <= 45, "dollar_cost_bobby_paul")
    model.addConstr(1 * paul_hours + 7 * ringo_hours <= 47, "dollar_cost_paul_ringo")
    model.addConstr(5 * bobby_hours + 1 * paul_hours + 7 * ringo_hours <= 26, "dollar_cost_all")
    model.addConstr(4 * bobby_hours + 9 * paul_hours <= 52, "quit_index_bobby_paul_max")
    model.addConstr(9 * paul_hours + 5 * ringo_hours <= 37, "quit_index_paul_ringo_max")
    model.addConstr(4 * bobby_hours + 9 * paul_hours + 5 * ringo_hours <= 37, "quit_index_all_max")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Bobby Hours: %g' % bobby_hours.x)
        print('Paul Hours: %g' % paul_hours.x)
        print('Ringo Hours: %g' % ringo_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
