
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Bobby
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Paul
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo

    # Objective function: maximize 4*x0 + 5*x1 + 3*x2
    model.setObjective(4*x0 + 5*x1 + 3*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x0 + 7*x2 >= 16)
    model.addConstr(9*x1 + 5*x2 >= 18)
    model.addConstr(4*x0 + 9*x1 >= 12)
    model.addConstr(4*x0 + 9*x1 + 5*x2 >= 15)
    model.addConstr(5*x0 + x1 <= 45)
    model.addConstr(x1 + 7*x2 <= 47)
    model.addConstr(5*x0 + x1 + 7*x2 <= 26)
    model.addConstr(4*x0 + 9*x1 <= 52)
    model.addConstr(9*x1 + 5*x2 <= 37)
    model.addConstr(4*x0 + 9*x1 + 5*x2 <= 37)

    # Non-negativity constraints
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
