
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_A")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B6")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B5")


# Set objective function
m.setObjective(5.19 * x0 + 8.36 * x1 + 4.74 * x2 + 3.83 * x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * x0 + 4 * x3 >= 13, "c0")
m.addConstr(12 * x0 + 12 * x1 + 4 * x3 >= 15, "c1")
m.addConstr(12 * x1 + 13 * x2 + 4 * x3 >= 15, "c2")
m.addConstr(10 * x0 + 9 * x2 >= 28, "c3")
m.addConstr(10 * x0 + 14 * x3 >= 33, "c4")
m.addConstr(10 * x0 + 9 * x2 + 14 * x3 >= 44, "c5")
m.addConstr(9 * x1 + 9 * x2 + 14 * x3 >= 44, "c6")
m.addConstr(4 * x2 + 11 * x3 >= 28, "c7")
m.addConstr(2 * x0 + 11 * x3 >= 30, "c8")
m.addConstr(2 * x0 + 8 * x1 >= 26, "c9")
m.addConstr(8 * x1 + 4 * x2 >= 30, "c10")
m.addConstr(8 * x1 + 4 * x2 + 11 * x3 >= 38, "c11")
m.addConstr(12 * x0 + 12 * x1 <= 63, "c12")
m.addConstr(12 * x1 + 13 * x2 <= 59, "c13")
m.addConstr(12 * x0 + 12 * x1 + 13 * x2 <= 62, "c14")
m.addConstr(12 * x0 + 12 * x1 + 4 * x3 <= 57, "c15")
m.addConstr(12 * x1 + 13 * x2 + 4 * x3 <= 45, "c16")
m.addConstr(12 * x0 + 12 * x1 + 13 * x2 + 4 * x3 <= 45, "c17")
m.addConstr(10 * x0 + 14 * x3 <= 193, "c18")
m.addConstr(10 * x0 + 9 * x2 <= 183, "c19")
m.addConstr(10 * x0 + 9 * x1 <= 162, "c20")
m.addConstr(9 * x1 + 9 * x2 <= 118, "c21")
m.addConstr(10 * x0 + 9 * x2 + 14 * x3 <= 196, "c22")
m.addConstr(10 * x0 + 9 * x1 + 9 * x2 + 14 * x3 <= 196, "c23")
m.addConstr(2 * x0 + 11 * x3 <= 65, "c24")
m.addConstr(8 * x1 + 4 * x2 <= 58, "c25")
m.addConstr(2 * x0 + 8 * x1 <= 77, "c26")
m.addConstr(2 * x0 + 8 * x1 + 4 * x2 + 11 * x3 <= 77, "c27")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

