
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="milligrams of vitamin A", lb=0)
x2 = model.addVar(name="grams of fat", lb=0)
x3 = model.addVar(name="milligrams of vitamin B6", lb=0)
x4 = model.addVar(name="milligrams of vitamin B5", lb=0)

# Define the objective function
model.setObjective(5.19*x1 + 8.36*x2 + 4.74*x3 + 3.83*x4, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(12*x1 <= 75)
model.addConstr(10*x1 <= 221)
model.addConstr(2*x1 <= 166)
model.addConstr(12*x2 <= 75)
model.addConstr(9*x2 <= 221)
model.addConstr(8*x2 <= 166)
model.addConstr(13*x3 <= 75)
model.addConstr(9*x3 <= 221)
model.addConstr(4*x3 <= 166)
model.addConstr(4*x4 <= 75)
model.addConstr(14*x4 <= 221)
model.addConstr(11*x4 <= 166)
model.addConstr(12*x1 + 4*x4 >= 13)
model.addConstr(12*x1 + 12*x2 + 4*x4 >= 15)
model.addConstr(12*x2 + 13*x3 + 4*x4 >= 15)
model.addConstr(12*x1 + 12*x2 + 4*x4 >= 11)
model.addConstr(12*x2 + 13*x3 + 4*x4 >= 11)
model.addConstr(10*x1 + 9*x3 >= 28)
model.addConstr(10*x1 + 14*x4 >= 33)
model.addConstr(10*x1 + 9*x3 + 14*x4 >= 44)
model.addConstr(9*x2 + 9*x3 + 14*x4 >= 44)
model.addConstr(10*x1 + 9*x3 + 14*x4 >= 35)
model.addConstr(9*x2 + 9*x3 + 14*x4 >= 35)
model.addConstr(4*x3 + 11*x4 >= 28)
model.addConstr(2*x1 + 11*x4 >= 30)
model.addConstr(2*x1 + 8*x2 >= 26)
model.addConstr(8*x2 + 4*x3 >= 30)
model.addConstr(8*x2 + 4*x3 + 11*x4 >= 38)
model.addConstr(12*x1 + 12*x2 <= 63)
model.addConstr(12*x2 + 13*x3 <= 59)
model.addConstr(12*x1 + 12*x2 + 13*x3 <= 62)
model.addConstr(12*x1 + 12*x2 + 4*x4 <= 57)
model.addConstr(12*x2 + 13*x3 + 4*x4 <= 45)
model.addConstr(12*x1 + 12*x2 + 13*x3 + 4*x4 <= 45)
model.addConstr(10*x1 + 14*x4 <= 193)
model.addConstr(10*x1 + 9*x3 <= 183)
model.addConstr(10*x1 + 9*x2 <= 162)
model.addConstr(9*x2 + 9*x3 <= 118)
model.addConstr(10*x1 + 9*x3 + 14*x4 <= 196)
model.addConstr(10*x1 + 9*x2 + 9*x3 + 14*x4 <= 196)
model.addConstr(2*x1 + 11*x4 <= 65)
model.addConstr(8*x2 + 4*x3 <= 58)
model.addConstr(2*x1 + 8*x2 <= 77)
model.addConstr(2*x1 + 8*x2 + 4*x3 + 11*x4 <= 77)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("milligrams of vitamin A: ", x1.varValue)
    print("grams of fat: ", x2.varValue)
    print("milligrams of vitamin B6: ", x3.varValue)
    print("milligrams of vitamin B5: ", x4.varValue)
else:
    print("The model is infeasible")
