
import gurobipy as gp

# Create a new model
model = gp.Model("Maximize_Hours")

# Create variables
ringo = model.addVar(vtype=gp.GRB.INTEGER, name="ringo")
paul = model.addVar(vtype=gp.GRB.INTEGER, name="paul")
peggy = model.addVar(vtype=gp.GRB.INTEGER, name="peggy")
george = model.addVar(vtype=gp.GRB.INTEGER, name="george")
laura = model.addVar(vtype=gp.GRB.INTEGER, name="laura")
bobby = model.addVar(vtype=gp.GRB.INTEGER, name="bobby")
mary = model.addVar(vtype=gp.GRB.INTEGER, name="mary")


# Set objective function
model.setObjective(4 * ringo + 9 * paul + 8 * peggy + 6 * george + laura + 6 * bobby + 2 * mary, gp.GRB.MAXIMIZE)

# Resource and attribute data
resources = {
    'r0': {'description': 'paperwork competence rating', 'upper_bound': 319, 'x0': 19, 'x1': 31, 'x2': 30, 'x3': 30, 'x4': 11, 'x5': 6, 'x6': 15},
    'r1': {'description': 'likelihood to quit index', 'upper_bound': 589, 'x0': 7, 'x1': 34, 'x2': 28, 'x3': 2, 'x4': 19, 'x5': 1, 'x6': 18},
    'r2': {'description': 'computer competence rating', 'upper_bound': 368, 'x0': 1, 'x1': 5, 'x2': 12, 'x3': 24, 'x4': 32, 'x5': 21, 'x6': 34}
}

# Add constraints based on the JSON representation
with open('constraints.json', 'r') as f:
    import json
    data = json.load(f)

for constraint_str in data['constraints']:
    model.addConstr(eval(constraint_str))


# Add resource constraints (if applicable - these were not explicitly stated in the problem description but are included here for completeness)
# for resource, data in resources.items():
#     model.addConstr(sum(data[f'x{i}'] * vars()[names[i]] for i in range(len(names))) <= data['upper_bound'], resource)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

