
import gurobi as gp

# Define model
m = gp.Model()

# Define variables
x1 = m.addVar(lb=0, name="rotisserie_chickens", vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(lb=0, name="chicken_breasts", vtype=gp.GRB.CONTINUOUS)
x3 = m.addVar(lb=0, name="sashimi", vtype=gp.GRB.CONTINUOUS)
x4 = m.addVar(lb=0, name="chicken_thighs", vtype=gp.GRB.CONTINUOUS)
x5 = m.addVar(lb=0, name="strips_of_bacon", vtype=gp.GRB.CONTINUOUS)
x6 = m.addVar(lb=0, name="oreos", vtype=gp.GRB.CONTINUOUS)

# Objective function
m.setObjective(4*x1*x2 + 6*x1*x3 + 9*x1*x4 + 9*x1*x5 + 7*x1*x6 + 
               x2*x3 + 6*x2*x4 + 5*x2*x5 + 2*x2*x6 + 
               x3**2 + 3*x3*x4 + 7*x3*x5 + 8*x3*x6 + 
               9*x4*x5 + 5*x5**2 + 6*x5*x6 + 
               8*x6**2 + 
               3*x1 + 2*x3 + 2*x4 + 7*x5 + 7*x6, gp.GRB.MINIMIZE)

# Constraints
# Resource constraints
m.addConstr(15*x1 + 17*x2 + 5*x3 + 6*x4 + 9*x5 + 8*x6 <= 607)
m.addConstr(6*x1 + 27*x2 + 8*x3 + 1*x4 + 22*x5 + 23*x6 <= 360)
m.addConstr(26*x1 + 8*x2 + 9*x3 + 2*x4 + 8*x5 + 5*x6 <= 292)
m.addConstr(1*x1 + 6*x2 + 3*x3 + 8*x4 + 9*x5 + 23*x6 <= 286)
m.addConstr(29*x1 + 25*x2 + 11*x3 + 22*x4 + 17*x5 + 18*x6 <= 405)

# Calcium constraints
m.addConstr(6*x4 + 9*x5 >= 68)
m.addConstr(17*x2 + 5*x3 >= 84)
# Add all constraints...

# Optimize
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
    print("x6: ", x6.varValue)
else:
    print("No optimal solution found")
