
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="hours_worked_by_Paul", vtype=gurobi.GRB.INTEGER)  # Integer variable for Paul
x2 = model.addVar(name="hours_worked_by_Ringo")  # Continuous variable for Ringo

# Define the objective function
model.setObjective(8.09 * x1 + 3.83 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(28 * x1 + 8 * x2 >= 56, name="paperwork_competence_rating")
model.addConstr(25 * x1 + 29 * x2 >= 65, name="productivity_rating")
model.addConstr(5 * x1 + 5 * x2 >= 28, name="likelihood_to_quit_index")
model.addConstr(3 * x1 + 16 * x2 >= 51, name="organization_score")
model.addConstr(-3 * x1 + 10 * x2 >= 0, name="linear_combination_hours_worked")
model.addConstr(28 * x1 + 8 * x2 <= 139, name="upper_bound_paperwork_competence_rating")
model.addConstr(25 * x1 + 29 * x2 <= 122, name="upper_bound_productivity_rating")
model.addConstr(5 * x1 + 5 * x2 <= 147, name="upper_bound_likelihood_to_quit_index")
model.addConstr(3 * x1 + 16 * x2 <= 205, name="upper_bound_organization_score")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by Ringo: ", x2.varValue)
else:
    print("The model is infeasible")
