
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="milligrams of vitamin B4")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams of vitamin C")


# Set objective function
m.setObjective(1*x0 + 5*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1*x0 + 6*x1 >= 52, "c0")
m.addConstr(-1*x0 + 1*x1 >= 0, "c1")
m.addConstr(1*x0 + 6*x1 <= 111, "c2")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal objective value:", m.objVal)
    print("milligrams of vitamin B4:", x0.x)
    print("milligrams of vitamin C:", x1.x)

