
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B4")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")

# Set the objective function
m.setObjective(1*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1*x1 + 6*x2 >= 52, "Muscle_Growth_Index_Min")
m.addConstr(-1*x1 + 1*x2 >= 0, "Vitamin_B4_Vitamin_C_Relation")
m.addConstr(1*x1 + 6*x2 <= 111, "Muscle_Growth_Index_Max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B4: {x1.x}")
    print(f"Milligrams of Vitamin C: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
