
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_vitamin_B4", vtype=gurobi.GRB.INTEGER, ub=129)
    x2 = model.addVar(name="milligrams_of_vitamin_C")

    # Set the objective function
    model.setObjective(1*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + 6*x2 >= 52)
    model.addConstr(-x1 + x2 >= 0)
    model.addConstr(x1 + 6*x2 <= 111)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B4: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
