
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(name="milligrams of calcium")
x1 = m.addVar(name="grams of carbohydrates")
x2 = m.addVar(name="milligrams of vitamin B4")


# Set objective function
m.setObjective(3.0*x0**2 + 9.58*x0*x1 + 7.74*x0*x2 + 1.46*x1*x2 + 8.91*x2**2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 + 21*x1 + 21*x2 <= 334, "r0")
m.addConstr(24*x0 + 6*x1 + 29*x2 <= 327, "r1")
m.addConstr(17*x0 + 20*x1 + 23*x2 <= 156, "r2")
m.addConstr(14*x0 + 25*x1 + 25*x2 <= 213, "r3")
m.addConstr(23*x0 + 4*x1 + 15*x2 <= 316, "r4")
m.addConstr(3*x0 + 21*x2 >= 91, "c1")
m.addConstr(3*x0 + 21*x1 >= 86, "c2")
m.addConstr(17*x0 + 20*x1 + 23*x2 >= 41, "c3")
m.addConstr(14*x0**2 + 25*x1**2 >= 62, "c4")
m.addConstr(25*x1 + 25*x2 >= 52, "c5")
m.addConstr(4*x1**2 + 15*x2**2 >= 88, "c6")
m.addConstr(23*x0 + 4*x1 + 15*x2 >= 55, "c7")
m.addConstr(3*x0 + 21*x1 <= 257, "c8")
m.addConstr(3*x0 + 21*x2 <= 257, "c9")
m.addConstr(3*x0 + 21*x1 + 21*x2 <= 257, "c10")
m.addConstr(6*x1**2 + 29*x2**2 <= 214, "c11")
m.addConstr(24*x0**2 + 6*x1**2 <= 230, "c12")
m.addConstr(24*x0 + 6*x1 + 29*x2 <= 230, "c13")
m.addConstr(17*x0 + 23*x2 <= 83, "c14")
m.addConstr(17*x0 + 20*x1 + 23*x2 <= 83, "c15")
m.addConstr(14*x0 + 25*x1 <= 76, "c16")
m.addConstr(25*x1 + 25*x2 <= 158, "c17")
m.addConstr(14*x0**2 + 25*x2**2 <= 181, "c18")
m.addConstr(14*x0 + 25*x1 + 25*x2 <= 181, "c19")
m.addConstr(23*x0**2 + 15*x2**2 <= 163, "c20")
m.addConstr(23*x0 + 4*x1 <= 220, "c21")
m.addConstr(4*x1 + 15*x2 <= 309, "c22")
m.addConstr(23*x0 + 4*x1 + 15*x2 <= 309, "c23")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"  milligrams of calcium: {x0.x}")
    print(f"  grams of carbohydrates: {x1.x}")
    print(f"  milligrams of vitamin B4: {x2.x}")
    print(f"  Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

