
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of calcium")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams of carbohydrates")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B4")

    # Objective function
    model.setObjective(3.0*x1**2 + 9.58*x1*x2 + 7.74*x1*x3 + 1.46*x2*x3 + 8.91*x3**2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x1 <= 334)
    model.addConstr(24*x1 <= 327)
    model.addConstr(17*x1 <= 156)
    model.addConstr(14*x1 <= 213)
    model.addConstr(23*x1 <= 316)
    model.addConstr(21*x2 <= 334)
    model.addConstr(6*x2 <= 327)
    model.addConstr(20*x2 <= 156)
    model.addConstr(25*x2 <= 213)
    model.addConstr(4*x2 <= 316)
    model.addConstr(21*x3 <= 334)
    model.addConstr(29*x3 <= 327)
    model.addConstr(23*x3 <= 156)
    model.addConstr(25*x3 <= 213)
    model.addConstr(15*x3 <= 316)
    model.addConstr(3*x1 + 21*x3 >= 91)
    model.addConstr(3*x1 + 21*x2 >= 86)
    model.addConstr(17*x1 + 20*x2 + 23*x3 >= 41)
    model.addConstr(14*x1**2 + 25*x2**2 >= 62)
    model.addConstr(25*x2 + 25*x3 >= 52)
    model.addConstr(4*x2**2 + 15*x3**2 >= 88)
    model.addConstr(23*x1 + 4*x2 + 15*x3 >= 55)
    model.addConstr(3*x1 + 21*x2 <= 257)
    model.addConstr(3*x1 + 21*x3 <= 257)
    model.addConstr(3*x1 + 21*x2 + 21*x3 <= 257)
    model.addConstr(6*x2**2 + 29*x3**2 <= 214)
    model.addConstr(24*x1**2 + 6*x2**2 <= 230)
    model.addConstr(24*x1 + 6*x2 + 29*x3 <= 230)
    model.addConstr(17*x1 + 23*x3 <= 83)
    model.addConstr(17*x1 + 20*x2 + 23*x3 <= 83)
    model.addConstr(14*x1 + 25*x2 <= 76)
    model.addConstr(25*x2 + 25*x3 <= 158)
    model.addConstr(14*x1**2 + 25*x3**2 <= 181)
    model.addConstr(14*x1 + 25*x2 + 25*x3 <= 181)
    model.addConstr(23*x1**2 + 15*x3**2 <= 163)
    model.addConstr(23*x1 + 4*x2 <= 220)
    model.addConstr(4*x2 + 15*x3 <= 309)
    model.addConstr(23*x1 + 4*x2 + 15*x3 <= 309)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Milligrams of calcium: ", x1.varValue)
        print("Grams of carbohydrates: ", x2.varValue)
        print("Milligrams of vitamin B4: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
