
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    laura_hours = m.addVar(lb=0, name="laura_hours")  # x0
    dale_hours = m.addVar(lb=0, name="dale_hours")  # x1


    # Set objective function
    m.setObjective(6.13 * laura_hours + 3.02 * dale_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4.87 * laura_hours + 1.72 * dale_hours >= 41, "productivity_lower_bound")
    m.addConstr(0.28 * laura_hours + 6.84 * dale_hours >= 18, "organization_lower_bound")
    m.addConstr(6.33 * laura_hours + 4.33 * dale_hours >= 17, "paperwork_lower_bound")
    m.addConstr(5.0 * laura_hours + 3.52 * dale_hours >= 110, "computer_lower_bound")
    m.addConstr(-laura_hours + 6 * dale_hours >= 0, "hours_relation")
    m.addConstr(4.87 * laura_hours + 1.72 * dale_hours <= 92, "productivity_upper_bound")
    m.addConstr(0.28 * laura_hours + 6.84 * dale_hours <= 58, "organization_upper_bound")
    m.addConstr(6.33 * laura_hours + 4.33 * dale_hours <= 37, "paperwork_upper_bound")
    m.addConstr(5.0 * laura_hours + 3.52 * dale_hours <= 231, "computer_upper_bound")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Laura Hours: %g' % laura_hours.x)
        print('Dale Hours: %g' % dale_hours.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

