
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Laura', lb=0)
    x2 = model.addVar(name='hours_worked_by_Dale', lb=0)

    # Define the objective function
    model.setObjective(6.13*x1 + 3.02*x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(4.87*x1 + 1.72*x2 >= 41)
    model.addConstr(0.28*x1 + 6.84*x2 >= 18)
    model.addConstr(6.33*x1 + 4.33*x2 >= 17)
    model.addConstr(5.0*x1 + 3.52*x2 >= 110)
    model.addConstr(-x1 + 6*x2 >= 0)
    model.addConstr(4.87*x1 + 1.72*x2 <= 92)
    model.addConstr(0.28*x1 + 6.84*x2 <= 58)
    model.addConstr(6.33*x1 + 4.33*x2 <= 37)
    model.addConstr(5.0*x1 + 3.52*x2 <= 231)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Laura: {x1.x}')
        print(f'Hours worked by Dale: {x2.x}')
        print(f'Objective function value: {model.objval}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
