
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x = {}
variables = ['basil plants', 'carrots', 'tulips', 'carnations', 'chrysanthemums', 'agave', 'strawberry bushes']
for i, var_name in enumerate(variables):
    x[i] = m.addVar(vtype=GRB.INTEGER, name=var_name)


# Set objective function
obj = 5.12 * x[0] + 2.21 * x[1] + 2.26 * x[2] + 4.05 * x[3] + 6.74 * x[4] + 6.53 * x[5] + 3.54 * x[6]
m.setObjective(obj, GRB.MINIMIZE)

# Set constraints
resources = {
    'r0': {'upper_bound': 275, 'x0': 1.78, 'x1': 2.35, 'x2': 9.37, 'x3': 7.74, 'x4': 1.43, 'x5': 5.75, 'x6': 5.53},
    'r1': {'upper_bound': 310, 'x0': 2.4, 'x1': 3.0, 'x2': 2.0, 'x3': 9.21, 'x4': 5.73, 'x5': 2.77, 'x6': 6.42}
}

m.addConstr(quicksum(resources['r0'][f'x{i}'] * x[i] for i in range(7)) <= resources['r0']['upper_bound'], "beauty_rating")
m.addConstr(quicksum(resources['r1'][f'x{i}'] * x[i] for i in range(7)) <= resources['r1']['upper_bound'], "water_need")


constraints = [
    (5,6,23,">="), (1,2,32,">="), (3,4,35,">="), (0,5,35,">="), (0,6,26,">="), (0,4,29,">="), (2,4,37,">="), (2,5,34,">="), (3,5,6,35,">="), (1,5,6,35,">="), (1,2,4,35,">="), (0,1,4,35,">="), (2,3,5,35,">="), (0,2,3,35,">="), (1,2,5,35,">="), (2,3,4,35,">="), (2,5,6,35,">="), (0,1,2,35,">="), (0,1,5,35,">="), (0,1,6,35,">="), (0,1,3,119,"<="), (0,2,3,92,"<="),
    (2,5,26,">=","water"), (4,5,31,">=","water"), (3,5,41,">=","water"), (1,4,32,">=","water"), (1,2,24,">=","water"), (2,6,40,">=","water"), (0,3,37,">=","water"), (0,6,14,">=","water"), (0,2,26,">=","water"), (0,1,5,29,">=","water"), (2,4,5,29,">=","water"), (0,1,6,29,">=","water"), (0,2,6,29,">=","water"), (1,3,6,29,">=","water"), (2,3,6,29,">=","water"), (0,1,5,40,">=","water"), (2,4,5,40,">=","water"), (0,1,6,40,">=","water"), (0,2,6,40,">=","water"), (1,3,6,40,">=","water"), (2,3,6,40,">=","water"), (0,1,5,35,">=","water"), (2,4,5,35,">=","water"), (0,1,6,35,">=","water"), (0,2,6,35,">=","water"), (1,3,6,35,">=","water"), (2,3,6,35,">=","water"), (0,1,5,22,">=","water"), (2,4,5,22,">=","water"), (0,1,6,22,">=","water"), (0,2,6,22,">=","water"), (1,3,6,22,">=","water"), (2,3,6,22,">=","water"), (0,1,5,26,">=","water"), (2,4,5,26,">=","water"), (0,1,6,26,">=","water"), (0,2,6,26,">=","water"), (1,3,6,26,">=","water"), (2,3,6,26,">=","water"), (0,1,5,38,">=","water"), (2,4,5,38,">=","water"), (0,1,6,38,">=","water"), (0,2,6,38,">=","water"), (1,3,6,38,">=","water"), (2,3,6,38,">=","water"), (0,1,2,3,4,5,6,38,">=","water"), (0,6,0,">=","8*-7"), (1,4,0,">=","-4*1"), (0,1,0,">=", "-4*4"), (0,5,152,"<=","water"), (3,4,109,"<=","water"), (0,1,84,"<=","water"), (1,3,291,"<=","water"), (2,3,81,"<=","water"), (3,6,60,"<=","water"), (5,6,241,"<=","water"), (1,4,5,286,"<=","water"), (3,5,6,168,"<=","water"), (0,3,5,295,"<=","water"), (2,4,6,133,"<=","water"), (0,1,6,114,"<=","water"), (0,3,4,176,"<=","water"), (0,1,2,176,"<=","water"), (2,5,6,45,"<=","water"), (0,1,3,259,"<=","water"), (1,3,6,222,"<=","water"), (2,3,6,137,"<=","water"), (2,5,66,"<=","water"), (0,4,5,127,"<=","water"), (1,2,4,189,"<=","water"), (1,3,5,58,"<=","water")
]

for constraint in constraints:
    indices = constraint[:-2]
    rhs = constraint[-2]
    sense = constraint[-1]
    if "water" in constraint:
        expr = quicksum(resources['r1'][f'x{i}'] * x[i] for i in indices)
    else:
        expr = quicksum(resources['r0'][f'x{i}'] * x[i] for i in indices)
    if sense == ">=":
        m.addConstr(expr >= rhs)
    elif sense == "<=":
        m.addConstr(expr <= rhs)
    else:  # Assuming sense is "=" if not ">=" or "<="
        m.addConstr(expr == rhs)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")

