
import gurobi as gp

m = gp.Model()
x1 = m.addVar(name="basil_plants", vtype=gp.GRB.INTEGER, lb=0)
x2 = m.addVar(name="carrots", vtype=gp.GRB.INTEGER, lb=0)
x3 = m.addVar(name="tulips", vtype=gp.GRB.INTEGER, lb=0)
x4 = m.addVar(name="carnations", vtype=gp.GRB.INTEGER, lb=0)
x5 = m.addVar(name="chrysanthemums", vtype=gp.GRB.INTEGER, lb=0)
x6 = m.addVar(name="agave", vtype=gp.GRB.INTEGER, lb=0)
x7 = m.addVar(name="strawberry_bushes", vtype=gp.GRB.INTEGER, lb=0)

m.setObjective(5.12 * x1 + 2.21 * x2 + 2.26 * x3 + 4.05 * x4 + 6.74 * x5 + 6.53 * x6 + 3.54 * x7, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(1.78 * x1 + 2.35 * x2 + 9.37 * x3 + 7.74 * x4 + 1.43 * x5 + 5.75 * x6 + 5.53 * x7 <= 275)
m.addConstr(5.75 * x6 + 5.53 * x7 >= 23)
m.addConstr(2.35 * x2 + 9.37 * x3 >= 32)
m.addConstr(7.74 * x4 + 1.43 * x5 >= 35)
m.addConstr(1.78 * x1 + 5.75 * x6 >= 35)
m.addConstr(1.78 * x1 + 5.53 * x7 >= 26)
m.addConstr(1.78 * x1 + 1.43 * x5 >= 29)
m.addConstr(9.37 * x3 + 1.43 * x5 >= 37)
m.addConstr(9.37 * x3 + 5.75 * x6 >= 34)
m.addConstr(7.74 * x4 + 5.75 * x6 + 5.53 * x7 >= 35)
m.addConstr(2.4 * x1 + 3.0 * x2 + 2.0 * x3 + 9.21 * x4 + 5.73 * x5 + 2.77 * x6 + 6.42 * x7 <= 310)
m.addConstr(2.0 * x3 + 2.77 * x6 >= 26)

m.optimize()

print("Objective: ", m.objval)
print("basil_plants: ", x1.varValue)
print("carrots: ", x2.varValue)
print("tulips: ", x3.varValue)
print("carnations: ", x4.varValue)
print("chrysanthemums: ", x5.varValue)
print("agave: ", x6.varValue)
print("strawberry_bushes: ", x7.varValue)

sym_variables = [('x1', 'basil_plants'), ('x2', 'carrots'), ('x3', 'tulips'), ('x4', 'carnations'), ('x5', 'chrysanthemums'), ('x6', 'agave'), ('x7', 'strawberry_bushes')]
objective_function = "5.12*x1 + 2.21*x2 + 2.26*x3 + 4.05*x4 + 6.74*x5 + 6.53*x6 + 3.54*x7"
constraints = [
    "1.78*x1 + 2.35*x2 + 9.37*x3 + 7.74*x4 + 1.43*x5 + 5.75*x6 + 5.53*x7 <= 275",
    "5.75*x6 + 5.53*x7 >= 23",
    "2.35*x2 + 9.37*x3 >= 32",
    "7.74*x4 + 1.43*x5 >= 35",
    "1.78*x1 + 5.75*x6 >= 35",
    "1.78*x1 + 5.53*x7 >= 26",
    "1.78*x1 + 1.43*x5 >= 29",
    "9.37*x3 + 1.43*x5 >= 37",
    "9.37*x3 + 5.75*x6 >= 34",
    "7.74*x4 + 5.75*x6 + 5.53*x7 >= 35",
    "2.4*x1 + 3.0*x2 + 2.0*x3 + 9.21*x4 + 5.73*x5 + 2.77*x6 + 6.42*x7 <= 310",
    "2.0*x3 + 2.77*x6 >= 26",
]

print("\nSymbolic Representation:")
print("sym_variables: ", sym_variables)
print("objective_function: ", objective_function)
print("constraints: ", constraints)
