
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
lemons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")
pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
corn_cobs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
chicken_drumsticks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_drumsticks")


# Set objective function
m.setObjective(6.83 * bananas + 5.14 * green_beans + 8.56 * lemons + 2.48 * pickles + 6.61 * chicken_thighs + 4.45 * corn_cobs + 2.37 * chicken_drumsticks, gp.GRB.MINIMIZE)

# Add constraints

m.addConstr(3 * pickles + 3 * corn_cobs >= 28)
m.addConstr(3 * bananas + 7 * chicken_drumsticks >= 31)
m.addConstr(3 * corn_cobs + 7 * chicken_drumsticks >= 20)
m.addConstr(6 * green_beans + 5 * pickles >= 15)
m.addConstr(3 * bananas + 5 * pickles >= 34)
m.addConstr(7 * chicken_thighs + 7 * chicken_drumsticks >= 32)


# Add resource constraints
m.addConstr(3 * bananas + 6 * green_beans + 4 * lemons + 5 * pickles + 7 * chicken_thighs + 3 * corn_cobs + 7 * chicken_drumsticks <= 249)
m.addConstr(7 * bananas + 3 * green_beans + 4 * lemons + 5 * pickles + 4 * chicken_thighs + 3 * corn_cobs + 4 * chicken_drumsticks <= 202)

#Additional constraints
m.addConstr(10 * green_beans - 8 * pickles >= 0)
m.addConstr(-6 * lemons + 2 * chicken_thighs >= 0)
m.addConstr(-2 * bananas + 5 * pickles >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

