
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, name="milligrams_of_iron")  # Iron
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_K")  # Vitamin K
x2 = m.addVar(lb=0, name="milligrams_of_potassium")  # Potassium
x3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="milligrams_of_vitamin_B7")  # Vitamin B7


# Set objective function
m.setObjective(6.58*x0**2 + 4.47*x0*x1 + 8.39*x0*x3 + 1.1*x1**2 + 9.62*x1*x2 + 5.28*x1*x3 + 6.95*x2**2 + 9.93*x2*x3 + 3.62*x0 + 8.76*x1 + 4.65*x2 + 1.84*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(23*x0 + 1*x1 + 3*x3 >= 65)
m.addConstr(23*x0 + 11*x2 + 3*x3 >= 65)
m.addConstr(1*x1**2 + 11*x2**2 + 3*x3**2 >= 65)
m.addConstr(23*x0 + 1*x1 + 3*x3 >= 57)
m.addConstr(23*x0**2 + 11*x2**2 + 3*x3**2 >= 57)
m.addConstr(1*x1 + 11*x2 + 3*x3 >= 57)
m.addConstr(23*x0 + 1*x1 + 3*x3 >= 40)
m.addConstr(23*x0 + 11*x2 + 3*x3 >= 40)
m.addConstr(1*x1 + 11*x2 + 3*x3 >= 40)
m.addConstr(2*x1 + 27*x3 >= 52)
m.addConstr(17*x0 + 2*x1 + 27*x3 >= 45)
m.addConstr(27*x0 + 7*x2 >= 44)
m.addConstr(7*x2 + 24*x3 >= 30)
m.addConstr(27*x0**2 + 7*x2**2 + 24*x3**2 >= 48)
m.addConstr(29*x1 + 7*x2 + 24*x3 >= 48)
m.addConstr(27*x0 + 29*x1 + 24*x3 >= 48)
m.addConstr(27*x0 + 7*x2 + 24*x3 >= 54)
m.addConstr(29*x1**2 + 7*x2**2 + 24*x3**2 >= 54)
m.addConstr(27*x0**2 + 29*x1**2 + 24*x3**2 >= 54)
m.addConstr(27*x0**2 + 7*x2**2 + 24*x3**2 >= 54)
m.addConstr(29*x1 + 7*x2 + 24*x3 >= 54)
m.addConstr(27*x0**2 + 29*x1**2 + 24*x3**2 >= 54)
m.addConstr(23*x0 + 11*x2 <= 108)
m.addConstr(1*x1 + 3*x3 <= 172)
m.addConstr(23*x0 + 1*x1 <= 215)
m.addConstr(1*x1 + 11*x2 <= 87)
m.addConstr(11*x2 + 3*x3 <= 188)
m.addConstr(23*x0 + 1*x1 + 11*x2 + 3*x3 <= 188)
m.addConstr(17*x0 + 27*x3 <= 93)
m.addConstr(17*x0**2 + 25*x2**2 <= 90)
m.addConstr(2*x1 + 27*x3 <= 93)
m.addConstr(2*x1 + 25*x2 + 27*x3 <= 223)
m.addConstr(17*x0 + 2*x1 + 25*x2 <= 65)
m.addConstr(17*x0 + 25*x2 + 27*x3 <= 176)
m.addConstr(17*x0 + 2*x1 + 25*x2 + 27*x3 <= 176)
m.addConstr(27*x0**2 + 29*x1**2 <= 168)
m.addConstr(7*x2 + 24*x3 <= 178)
m.addConstr(29*x1**2 + 7*x2**2 <= 111)
m.addConstr(27*x0 + 29*x1 + 7*x2 + 24*x3 <= 111)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

