
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Mary")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Laura")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bobby")


# Set objective function
m.setObjective(4 * mary + 4 * dale + 7 * paul + 5 * laura + 1 * bobby, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * dale + 11 * bobby >= 39)
m.addConstr(19 * mary + 4 * laura >= 44)
m.addConstr(19 * mary + 11 * bobby >= 94)
m.addConstr(19 * mary + 18 * dale + 9 * paul >= 107)
m.addConstr(19 * mary + 18 * dale + 9 * paul + 4 * laura + 11 * bobby >= 107)
m.addConstr(15 * laura + 4 * bobby >= 113)
m.addConstr(22 * mary + 4 * bobby >= 86)
m.addConstr(16 * paul + 4 * bobby >= 86)
m.addConstr(24 * dale + 16 * paul + 4 * bobby >= 87)
m.addConstr(22 * mary + 24 * dale + 15 * laura >= 87)
m.addConstr(24 * dale + 15 * laura + 4 * bobby >= 87)
m.addConstr(24 * dale + 16 * paul + 4 * bobby >= 94)
m.addConstr(22 * mary + 24 * dale + 15 * laura >= 94)
m.addConstr(24 * dale + 15 * laura + 4 * bobby >= 94)
m.addConstr(24 * dale + 16 * paul + 4 * bobby >= 77)
m.addConstr(22 * mary + 24 * dale + 15 * laura >= 77)
m.addConstr(24 * dale + 15 * laura + 4 * bobby >= 77)
m.addConstr(22 * mary + 24 * dale + 16 * paul + 15 * laura + 4 * bobby >= 77)
m.addConstr(2 * laura + 6 * bobby >= 51)
m.addConstr(10 * mary + 6 * bobby >= 51)
m.addConstr(10 * mary + 7 * dale >= 96)
m.addConstr(7 * dale + 7 * paul >= 79)
m.addConstr(7 * dale + 2 * laura >= 52)
m.addConstr(10 * mary + 7 * paul >= 96)
m.addConstr(7 * paul + 6 * bobby >= 108)
m.addConstr(10 * mary + 7 * dale + 7 * paul + 2 * laura + 6 * bobby >= 108)
m.addConstr(6 * dale - 6 * bobby >= 0)
m.addConstr(-2 * mary + 3 * paul >= 0)
m.addConstr(18 * dale + 9 * paul <= 523)
m.addConstr(19 * mary + 18 * dale + 4 * laura <= 355)
m.addConstr(19 * mary + 18 * dale + 9 * paul <= 354)
m.addConstr(16 * paul + 4 * bobby <= 213)
m.addConstr(24 * dale + 4 * bobby <= 284)
m.addConstr(24 * dale + 16 * paul <= 478)
m.addConstr(15 * laura + 4 * bobby <= 202)
m.addConstr(22 * mary + 4 * bobby <= 392)
m.addConstr(24 * dale + 15 * laura <= 249)
m.addConstr(16 * paul + 15 * laura + 4 * bobby <= 215)
m.addConstr(22 * mary + 15 * laura + 4 * bobby <= 483)
m.addConstr(22 * mary + 24 * dale + 16 * paul <= 321)
m.addConstr(24 * dale + 16 * paul + 15 * laura <= 349)
m.addConstr(22 * mary + 24 * dale + 15 * laura <= 221)
m.addConstr(7 * dale + 2 * laura <= 582)
m.addConstr(7 * paul + 2 * laura <= 183)
m.addConstr(10 * mary + 7 * paul <= 325)
m.addConstr(7 * paul + 6 * bobby <= 450)
m.addConstr(2 * laura + 6 * bobby <= 406)
m.addConstr(7 * dale + 6 * bobby <= 299)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

