
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")


# Set objective function
m.setObjective(x0**2 + 9*x0*x1 + 8*x1**2 + x1*x2 + 7*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.46*x0 + 6.72*x1 + 10.12*x2 >= 18)
m.addConstr(1.82*x0 + 2.03*x1 + 5.95*x2 >= 34)
m.addConstr(6.95*x0 + 1.29*x1 + 12.71*x2 >= 47)
m.addConstr(8.81*x0 + 1.9*x1 + 9.2*x2 >= 14)
m.addConstr(4.17*x0 + 10.11*x1 + 0.97*x2 >= 30)
m.addConstr(0.46*x0**2 + 10.12*x2**2 >= 39)
m.addConstr(6.72*x1 + 10.12*x2 >= 18)
m.addConstr(1.82*x0 + 2.03*x1 >= 16)
m.addConstr(2.03*x1 + 5.95*x2 >= 36)
m.addConstr(6.95*x0 + 12.71*x2 >= 31)
m.addConstr(6.95*x0 + 1.29*x1 >= 47)
m.addConstr(8.81*x0**2 + 9.2*x2**2 >= 11)
m.addConstr(8.81*x0 + 1.9*x1 >= 14)
m.addConstr(4.17*x0 + 10.11*x1 >= 31)
m.addConstr(10.11*x1**2 + 0.97*x2**2 >= 30)
m.addConstr(5*x1 - 5*x2 >= 0)
m.addConstr(2.03*x1 + 5.95*x2 <= 88)
m.addConstr(1.82*x0**2 + 2.03*x1**2 <= 54)
m.addConstr(4.17*x0 + 10.11*x1 <= 62)
m.addConstr(4.17*x0**2 + 10.11*x1**2 + 0.97*x2**2 <= 96)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

