
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="x2", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x3 = m.addVar(name="x3", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
m.setObjective(1 * x1**2 + 9 * x1 * x2 + 8 * x2**2 + 1 * x2 * x3 + 7 * x2 + 7 * x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(0.46 * x1 <= 144)
m.addConstr(1.82 * x1 <= 116)
m.addConstr(6.95 * x1 <= 152)
m.addConstr(8.81 * x1 <= 76)
m.addConstr(4.17 * x1 <= 99)
m.addConstr(6.72 * x2 <= 144)
m.addConstr(2.03 * x2 <= 116)
m.addConstr(1.29 * x2 <= 152)
m.addConstr(1.9 * x2 <= 76)
m.addConstr(10.11 * x2 <= 99)
m.addConstr(10.12 * x3 <= 144)
m.addConstr(5.95 * x3 <= 116)
m.addConstr(12.71 * x3 <= 152)
m.addConstr(9.2 * x3 <= 76)
m.addConstr(0.97 * x3 <= 99)
m.addConstr(0.46 * x1**2 + 10.12 * x3**2 >= 39)
m.addConstr(6.72 * x2 + 10.12 * x3 >= 18)
m.addConstr(0.46 * x1 + 6.72 * x2 + 10.12 * x3 >= 18)
m.addConstr(1.82 * x1 + 2.03 * x2 >= 16)
m.addConstr(2.03 * x2 + 5.95 * x3 >= 36)
m.addConstr(1.82 * x1 + 2.03 * x2 + 5.95 * x3 >= 34)
m.addConstr(6.95 * x1 + 12.71 * x3 >= 31)
m.addConstr(6.95 * x1 + 1.29 * x2 >= 47)
m.addConstr(6.95 * x1 + 1.29 * x2 + 12.71 * x3 >= 47)
m.addConstr(8.81 * x1**2 + 9.2 * x3**2 >= 11)
m.addConstr(8.81 * x1 + 1.9 * x2 >= 14)
m.addConstr(8.81 * x1 + 1.9 * x2 + 9.2 * x3 >= 14)
m.addConstr(4.17 * x1 + 10.11 * x2 >= 31)
m.addConstr(10.11 * x2**2 + 0.97 * x3**2 >= 30)
m.addConstr(4.17 * x1 + 10.11 * x2 + 0.97 * x3 >= 30)
m.addConstr(5 * x2 - 5 * x3 >= 0)
m.addConstr(2.03 * x2 + 5.95 * x3 <= 88)
m.addConstr(1.82 * x1**2 + 2.03 * x2**2 <= 54)
m.addConstr(4.17 * x1 + 10.11 * x2 <= 62)
m.addConstr(4.17 * x1**2 + 10.11 * x2**2 + 0.97 * x3**2 <= 96)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
