
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
patches_per_day = m.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")
system_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")
automatic_alerts = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
intrusion_analysts = m.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")


# Set objective function
m.setObjective(2.34 * patches_per_day + 2.43 * system_administrators + 2.6 * automatic_alerts + 8.27 * intrusion_analysts, gp.GRB.MINIMIZE)

# Add constraints
resources = {
    'r0': {'upper_bound': 190, 'x0': 10, 'x1': 6, 'x2': 12, 'x3': 14},
    'r1': {'upper_bound': 183, 'x0': 9, 'x1': 13, 'x2': 2, 'x3': 5},
    'r2': {'upper_bound': 223, 'x0': 11, 'x1': 13, 'x2': 12, 'x3': 8},
    'r3': {'upper_bound': 204, 'x0': 5, 'x1': 12, 'x2': 10, 'x3': 11}
}

for r, data in resources.items():
    m.addConstr(data['x0'] * patches_per_day + data['x1'] * system_administrators + data['x2'] * automatic_alerts + data['x3'] * intrusion_analysts <= data['upper_bound'], name=r)


constraints = [
    (10*patches_per_day + 14*intrusion_analysts >= 20),
    (10*patches_per_day + 12*automatic_alerts >= 30),
    (6*system_administrators + 14*intrusion_analysts >= 30),
    (10*patches_per_day + 6*system_administrators + 12*automatic_alerts >= 36),
    (10*patches_per_day + 12*automatic_alerts + 14*intrusion_analysts >= 36),
    (6*system_administrators + 12*automatic_alerts + 14*intrusion_analysts >= 36),
    (10*patches_per_day + 6*system_administrators + 12*automatic_alerts >= 46),
    (10*patches_per_day + 12*automatic_alerts + 14*intrusion_analysts >= 46),
    (6*system_administrators + 12*automatic_alerts + 14*intrusion_analysts >= 46),
    (10*patches_per_day + 6*system_administrators + 12*automatic_alerts >= 44),
    (10*patches_per_day + 12*automatic_alerts + 14*intrusion_analysts >= 44),
    (6*system_administrators + 12*automatic_alerts + 14*intrusion_analysts >= 44),
    (10*patches_per_day + 6*system_administrators + 12*automatic_alerts + 14*intrusion_analysts >= 44),
    (9*patches_per_day + 2*automatic_alerts >= 45),
    (9*patches_per_day + 13*system_administrators + 5*intrusion_analysts >= 29),
    (9*patches_per_day + 2*automatic_alerts + 5*intrusion_analysts >= 29),
    (9*patches_per_day + 13*system_administrators + 5*intrusion_analysts >= 23),
    (9*patches_per_day + 2*automatic_alerts + 5*intrusion_analysts >= 23),
    (9*patches_per_day + 13*system_administrators + 2*automatic_alerts + 5*intrusion_analysts >= 23),
    (11*patches_per_day + 8*intrusion_analysts >= 33),
    (11*patches_per_day + 13*system_administrators >= 49),
    (11*patches_per_day + 12*automatic_alerts >= 46),
    (13*system_administrators + 12*automatic_alerts >= 32),
    (13*system_administrators + 8*intrusion_analysts >= 33),
    (11*patches_per_day + 13*system_administrators + 12*automatic_alerts >= 45),
    (11*patches_per_day + 13*system_administrators + 12*automatic_alerts + 8*intrusion_analysts >= 45),
    (5*patches_per_day + 11*intrusion_analysts >= 29),
    (10*automatic_alerts + 11*intrusion_analysts >= 30),
    (5*patches_per_day + 12*system_administrators >= 19),
    (12*system_administrators + 10*automatic_alerts >= 29),
    (5*patches_per_day + 12*system_administrators + 10*automatic_alerts >= 44),
    (5*patches_per_day + 12*system_administrators + 10*automatic_alerts + 11*intrusion_analysts >= 44),
    (-10*automatic_alerts + intrusion_analysts >= 0),
    (-8*patches_per_day + system_administrators >= 0),
    (10*patches_per_day + 6*system_administrators + 14*intrusion_analysts <= 127),
    (10*patches_per_day + 6*system_administrators + 12*automatic_alerts <= 90),
    (6*system_administrators + 12*automatic_alerts + 14*intrusion_analysts <= 116),
    (13*system_administrators + 2*automatic_alerts + 5*intrusion_analysts <= 151),
    (5*patches_per_day + 12*system_administrators + 10*automatic_alerts <= 110),
    (5*patches_per_day + 12*system_administrators + 11*intrusion_analysts <= 156),
    (12*system_administrators + 10*automatic_alerts + 11*intrusion_analysts <= 138)
]

for constraint in constraints:
    m.addConstr(constraint)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

