
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
ringo = m.addVar(vtype=GRB.INTEGER, name="ringo")
hank = m.addVar(vtype=GRB.INTEGER, name="hank")
john = m.addVar(vtype=GRB.CONTINUOUS, name="john")
mary = m.addVar(vtype=GRB.CONTINUOUS, name="mary")
bobby = m.addVar(vtype=GRB.CONTINUOUS, name="bobby")
jean = m.addVar(vtype=GRB.INTEGER, name="jean")


# Set objective
m.setObjective(9.62*ringo**2 + 9.41*ringo*hank + 5.72*hank**2 + 3.24*mary*bobby + 6.61*bobby*jean + 6.6*jean**2 + 1.32*ringo + 3.12*bobby + 9.74*jean, GRB.MAXIMIZE)

# Add constraints

# Resource Constraints (simplified using provided data)
m.addConstr(9*ringo**2 + 9*hank**2 >= 19)
m.addConstr(7*mary**2 + 7*jean**2 >= 29)
m.addConstr(john + 7*mary >= 22)
# ... (rest of the constraints from the JSON "constraints" field)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ringo:', ringo.x)
    print('hank:', hank.x)
    print('john:', john.x)
    print('mary:', mary.x)
    print('bobby:', bobby.x)
    print('jean:', jean.x)

elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

