
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hot_dogs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hot_dogs")
bananas = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")
ham_sandwiches = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ham_sandwiches")
eggs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="eggs")


# Set objective function
m.setObjective(5*hot_dogs**2 + 4*hot_dogs*bananas + 3*hot_dogs*ham_sandwiches + 5*hot_dogs*eggs + 9*bananas**2 + 1*bananas*ham_sandwiches + 2*bananas*eggs + 5*ham_sandwiches**2 + 6*ham_sandwiches*eggs + 5*eggs**2 + 6*hot_dogs + 1*bananas + 5*ham_sandwiches + 4*eggs, GRB.MINIMIZE)

# Add constraints
m.addConstr(12*hot_dogs + 17*eggs >= 39)
m.addConstr(12*hot_dogs + 16*bananas >= 21)
m.addConstr(9*ham_sandwiches + 17*eggs >= 33)
m.addConstr(16*bananas + 9*ham_sandwiches + 17*eggs >= 34)
m.addConstr(12*hot_dogs + 16*bananas + 9*ham_sandwiches + 17*eggs >= 34)
m.addConstr(5*bananas + 12*eggs >= 13)
m.addConstr(16*hot_dogs + 5*bananas >= 8)
m.addConstr(16**2*hot_dogs**2 + 5**2*bananas**2 + 12**2*eggs**2 >= 22)
m.addConstr(16*hot_dogs + 5*bananas + 12*ham_sandwiches + 12*eggs >= 22)
m.addConstr(8*ham_sandwiches + 1*eggs >= 53)
m.addConstr(14**2*bananas**2 + 8**2*ham_sandwiches**2 >= 87)
m.addConstr(13*hot_dogs + 8*ham_sandwiches >= 53)
m.addConstr(13*hot_dogs + 14*bananas + 8*ham_sandwiches + 1*eggs >= 53)
m.addConstr(5*ham_sandwiches - 9*eggs >= 0)
m.addConstr(7*bananas**2 - 9*eggs**2 >= 0)
m.addConstr(12*hot_dogs + 16*bananas + 17*eggs <= 133)
m.addConstr(13*hot_dogs + 8*ham_sandwiches <= 87)
m.addConstr(13*hot_dogs + 14*bananas <= 192)
m.addConstr(14*bananas + 8*ham_sandwiches <= 155)
m.addConstr(8*ham_sandwiches + 1*eggs <= 208)

m.addConstr(12*hot_dogs + 16*bananas + 9*ham_sandwiches + 17*eggs <= 216)
m.addConstr(16*hot_dogs + 5*bananas + 12*ham_sandwiches + 12*eggs <= 93)
m.addConstr(13*hot_dogs + 14*bananas + 8*ham_sandwiches + 1*eggs <= 349)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

