
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
carbohydrates = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")
iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")

# Set objective function
m.setObjective(3.08 * carbohydrates + 2.45 * vitamin_b7 + 7.69 * vitamin_d + 5.19 * vitamin_b1 + 9.29 * iron, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * carbohydrates + 1 * vitamin_b7 + 2 * vitamin_d + 2 * vitamin_b1 + 6 * iron <= 109, "kidney_support_index")
m.addConstr(2 * vitamin_b1 + 6 * iron >= 15, "c1")
m.addConstr(4 * carbohydrates + 2 * vitamin_b1 >= 7, "c2")
m.addConstr(4 * carbohydrates + 6 * iron >= 18, "c3")
m.addConstr(2 * vitamin_d + 2 * vitamin_b1 >= 16, "c4")
m.addConstr(1 * vitamin_b7 + 2 * vitamin_b1 + 6 * iron >= 20, "c5")
m.addConstr(2 * vitamin_d + 2 * vitamin_b1 + 6 * iron >= 20, "c6")
m.addConstr(1 * vitamin_b7 + 2 * vitamin_d + 6 * iron >= 20, "c7")
m.addConstr(1 * vitamin_b7 + 2 * vitamin_d + 2 * vitamin_b1 >= 20, "c8")

m.addConstr(-10 * vitamin_b7 + 9 * iron >= 0, "c9")
m.addConstr(2 * vitamin_b7 - 9 * vitamin_b1 >= 0, "c10")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('\nCost: %g' % m.objVal)
    print('\nNutrients:')
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

