
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    x = m.addVars(6, lb=0, vtype=gp.GRB.CONTINUOUS, name=["granola bars", "eggs", "oreos", "apple pies", "lemons", "kiwis"])


    # Set objective function
    m.setObjective(3.55 * x[0] + 3.57 * x[1] + 2.41 * x[2] + 7.83 * x[3] + 5.78 * x[4] + 8.69 * x[5], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11 * x[0] + 32 * x[4] >= 26, "fiber_granola_lemons")
    m.addConstr(13 * x[1] + 2 * x[3] >= 54, "fiber_eggs_pies")
    m.addConstr(2 * x[3] + 24 * x[5] >= 50, "fiber_pies_kiwis")
    m.addConstr(11 * x[0] + 2 * x[3] >= 47, "fiber_granola_pies")
    m.addConstr(11 * x[0] + 13 * x[1] + 27 * x[2] + 2 * x[3] + 32 * x[4] + 24 * x[5] >= 47, "fiber_total_min")
    m.addConstr(4 * x[1] - 6 * x[3] >= 0, "eggs_pies_ratio")
    m.addConstr(4 * x[1] - 6 * x[5] >= 0, "eggs_kiwis_ratio")
    m.addConstr(-8 * x[1] + 2 * x[2] + 8 * x[4] >= 0, "eggs_oreos_lemons_ratio")
    m.addConstr(27 * x[2] + 2 * x[3] + 32 * x[4] <= 207, "fiber_oreos_pies_lemons_max")
    m.addConstr(11 * x[0] + 13 * x[1] + 27 * x[2] + 2 * x[3] + 32 * x[4] + 24 * x[5] <= 327, "fiber_total_max")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
