
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="granola_bars", lb=0)  # granola bars
x2 = model.addVar(name="eggs", lb=0)  # eggs
x3 = model.addVar(name="oreos", lb=0)  # oreos
x4 = model.addVar(name="apple_pies", lb=0)  # apple pies
x5 = model.addVar(name="lemons", lb=0)  # lemons
x6 = model.addVar(name="kiwis", lb=0)  # kiwis

# Objective function
model.setObjective(3.55 * x1 + 3.57 * x2 + 2.41 * x3 + 7.83 * x4 + 5.78 * x5 + 8.69 * x6, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(11 * x1 + 13 * x2 + 27 * x3 + 2 * x4 + 32 * x5 + 24 * x6 <= 327)  # total fiber
model.addConstr(11 * x1 + 32 * x5 >= 26)  # fiber from granola bars and lemons
model.addConstr(13 * x2 + 2 * x4 >= 54)  # fiber from eggs and apple pies
model.addConstr(2 * x4 + 24 * x6 >= 50)  # fiber from apple pies and kiwis
model.addConstr(11 * x1 + 2 * x4 >= 47)  # fiber from granola bars and apple pies
model.addConstr(11 * x1 + 13 * x2 + 27 * x3 + 2 * x4 + 32 * x5 + 24 * x6 >= 47)  # fiber from all
model.addConstr(4 * x2 - 6 * x4 >= 0)  # constraint on eggs and apple pies
model.addConstr(4 * x2 - 6 * x6 >= 0)  # constraint on eggs and kiwis
model.addConstr(-8 * x2 + 2 * x3 + 8 * x5 >= 0)  # constraint on eggs, oreos, and lemons
model.addConstr(27 * x3 + 2 * x4 + 32 * x5 <= 207)  # fiber from oreos, apple pies, and lemons

# Optimize
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("granola bars: ", x1.varValue)
    print("eggs: ", x2.varValue)
    print("oreos: ", x3.varValue)
    print("apple pies: ", x4.varValue)
    print("lemons: ", x5.varValue)
    print("kiwis: ", x6.varValue)
else:
    print("The model is infeasible")
