
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="grams_of_carbohydrates")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_magnesium")


    # Set objective function
    m.setObjective(4*x0 + 9*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7*x0 + 3*x1 >= 36, "c0")
    m.addConstr(10*x0 + 1*x1 >= 40, "c1")
    m.addConstr(3*x0 + 13*x1 >= 70, "c2")
    m.addConstr(-10*x0 + 5*x1 >= 0, "c3")
    m.addConstr(7*x0 + 3*x1 <= 103, "c4")
    m.addConstr(10*x0 + 1*x1 <= 78, "c5")
    m.addConstr(3*x0 + 13*x1 <= 143, "c6")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization was infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

