
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="grams_of_carbohydrates")
x2 = m.addVar(lb=0, name="milligrams_of_magnesium")

# Set the objective function
m.setObjective(4*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 3*x2 >= 36, "cardiovascular_support_index_min")
m.addConstr(7*x1 + 3*x2 <= 103, "cardiovascular_support_index_max")
m.addConstr(10*x1 + x2 >= 40, "immune_support_index_min")
m.addConstr(10*x1 + x2 <= 78, "immune_support_index_max")
m.addConstr(3*x1 + 13*x2 >= 70, "energy_stability_index_min")
m.addConstr(3*x1 + 13*x2 <= 143, "energy_stability_index_max")
m.addConstr(-10*x1 + 5*x2 >= 0, "additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of carbohydrates: {x1.x}")
    print(f"Milligrams of magnesium: {x2.x}")
else:
    print("No optimal solution found")
