
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # grams of carbohydrates
    x2 = model.addVar(name="x2", lb=0)  # milligrams of magnesium

    # Define the objective function
    model.setObjective(4 * x1 + 9 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7 * x1 + 3 * x2 >= 36, name="cardiovascular_support_index")
    model.addConstr(10 * x1 + x2 >= 40, name="immune_support_index")
    model.addConstr(3 * x1 + 13 * x2 >= 70, name="energy_stability_index")
    model.addConstr(-10 * x1 + 5 * x2 >= 0, name="balance_constraint")
    model.addConstr(7 * x1 + 3 * x2 <= 103, name="cardiovascular_support_index_upper_bound")
    model.addConstr(10 * x1 + x2 <= 78, name="immune_support_index_upper_bound")
    model.addConstr(3 * x1 + 13 * x2 <= 143, name="energy_stability_index_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of carbohydrates: {x1.varValue}")
        print(f"Milligrams of magnesium: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
