
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
    vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")


    # Set objective function
    m.setObjective(8.21 * vitamin_c + 1.87 * vitamin_b12, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12.75 * vitamin_c + 7.81 * vitamin_b12 >= 47, "muscle_growth_min")
    m.addConstr(0.69 * vitamin_c + 1.13 * vitamin_b12 >= 22, "digestive_support_min")
    m.addConstr(6 * vitamin_c - 3 * vitamin_b12 >= 0, "vitamin_ratio")
    m.addConstr(12.75 * vitamin_c + 7.81 * vitamin_b12 <= 87, "muscle_growth_max")
    m.addConstr(0.69 * vitamin_c + 1.13 * vitamin_b12 <= 52, "digestive_support_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Vitamin C: %g' % vitamin_c.x)
        print('Vitamin B12: %g' % vitamin_b12.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
