
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="milligrams_of_vitamin_C", lb=0)  # Assuming non-negative
x2 = model.addVar(name="milligrams_of_vitamin_B12", lb=0)  # Assuming non-negative

# Define the objective function
model.setObjective(8.21 * x1 + 1.87 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(12.75 * x1 + 7.81 * x2 >= 47)
model.addConstr(0.69 * x1 + 1.13 * x2 >= 22)
model.addConstr(6 * x1 - 3 * x2 >= 0)
model.addConstr(12.75 * x1 + 7.81 * x2 <= 87)
model.addConstr(0.69 * x1 + 1.13 * x2 <= 52)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin C: {x1.varValue}")
    print(f"Milligrams of vitamin B12: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
