
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Bill
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Mary
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Hank

    # Define the objective function
    model.setObjective(9.62 * x0 + 6.74 * x1 + 7.61 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4.81 * x0 + 10.91 * x1 >= 18)
    model.addConstr(4.81 * x0 + 10.91 * x1 + 7.87 * x2 >= 18)
    model.addConstr(10.28 * x0 + 0.89 * x1 + 11.33 * x2 >= 34)
    model.addConstr(0.62 * x0 + 8.79 * x2 >= 14)
    model.addConstr(11.77 * x1 + 8.79 * x2 >= 37)
    model.addConstr(5.35 * x0 + 8.39 * x1 + 11.28 * x2 >= 28)
    model.addConstr(11.19 * x1 + 9.05 * x2 <= 75)
    model.addConstr(9.76 * x0 + 11.19 * x1 + 9.05 * x2 <= 75)
    model.addConstr(4.81 * x0 + 7.87 * x2 <= 51)
    model.addConstr(4.81 * x0 + 10.91 * x1 + 7.87 * x2 <= 51)
    model.addConstr(10.28 * x0 + 11.33 * x2 <= 83)
    model.addConstr(0.89 * x1 + 11.33 * x2 <= 64)
    model.addConstr(10.28 * x0 + 0.89 * x1 + 11.33 * x2 <= 64)
    model.addConstr(0.62 * x0 + 8.79 * x2 <= 38)
    model.addConstr(11.77 * x1 + 8.79 * x2 <= 86)
    model.addConstr(0.62 * x0 + 11.77 * x1 + 8.79 * x2 <= 86)
    model.addConstr(5.35 * x0 + 8.39 * x1 <= 105)
    model.addConstr(5.35 * x0 + 11.28 * x2 <= 110)
    model.addConstr(5.35 * x0 + 8.39 * x1 + 11.28 * x2 <= 110)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Bill: ", x0.varValue)
        print("Hours worked by Mary: ", x1.varValue)
        print("Hours worked by Hank: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
