
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
apples = m.addVar(vtype=gp.GRB.INTEGER, name="apples")
cantaloupes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cantaloupes")
blueberry_pies = m.addVar(vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")
apple_pies = m.addVar(vtype=gp.GRB.CONTINUOUS, name="apple_pies")
ravioli = m.addVar(vtype=gp.GRB.INTEGER, name="ravioli")
milkshakes = m.addVar(vtype=gp.GRB.INTEGER, name="milkshakes")

# Set objective function
m.setObjective(3.16 * apples + 3.02 * cantaloupes + 9.82 * blueberry_pies + 7.32 * apple_pies + 8.48 * ravioli + 8.96 * milkshakes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * apples + 8 * ravioli >= 21)
m.addConstr(14 * cantaloupes + 8 * ravioli >= 28)
m.addConstr(3 * apples + 8 * blueberry_pies >= 15)
m.addConstr(14 * cantaloupes + 8 * blueberry_pies + 7 * milkshakes >= 15)
m.addConstr(3 * apple_pies + 8 * ravioli + 7 * milkshakes >= 15)
m.addConstr(14 * cantaloupes + 8 * blueberry_pies + 3 * apple_pies >= 15)
m.addConstr(14 * cantaloupes + 8 * blueberry_pies + 7 * milkshakes >= 22)
m.addConstr(3 * apple_pies + 8 * ravioli + 7 * milkshakes >= 22)
m.addConstr(14 * cantaloupes + 8 * blueberry_pies + 3 * apple_pies >= 22)
m.addConstr(14 * cantaloupes + 8 * blueberry_pies + 7 * milkshakes >= 28)
m.addConstr(3 * apple_pies + 8 * ravioli + 7 * milkshakes >= 28)
m.addConstr(14 * cantaloupes + 8 * blueberry_pies + 3 * apple_pies >= 28)
m.addConstr(apple_pies + 2 * milkshakes >= 16)
m.addConstr(9 * ravioli + 2 * milkshakes >= 18)
m.addConstr(cantaloupes + 2 * milkshakes >= 18)

# ... (rest of the constraints from the JSON)

m.addConstr(3 * apples + 14 * cantaloupes + 8 * blueberry_pies + 3 * apple_pies + 8 * ravioli + 7 * milkshakes <= 182)
m.addConstr(apples + cantaloupes + 4 * blueberry_pies + apple_pies + 9 * ravioli + 2 * milkshakes <= 179)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

