
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
oranges = m.addVar(vtype=gp.GRB.CONTINUOUS, name="oranges")
milkshakes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milkshakes")
pickles = m.addVar(vtype=gp.GRB.CONTINUOUS, name="pickles")

# Set objective function
m.setObjective(2.69 * oranges + 1.69 * milkshakes + 1.85 * pickles, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * oranges + 10 * pickles >= 33, "c1")
m.addConstr(2 * oranges + 9 * milkshakes >= 36, "c2")
m.addConstr(2 * oranges + 9 * milkshakes + 10 * pickles >= 36, "c3")
m.addConstr(11 * oranges + 13 * pickles >= 31, "c4")
m.addConstr(11 * oranges + 16 * milkshakes >= 25, "c5")
m.addConstr(11 * oranges + 16 * milkshakes + 13 * pickles >= 25, "c6")
m.addConstr(-8 * oranges + 4 * milkshakes >= 0, "c7")
m.addConstr(2 * milkshakes - 9 * pickles >= 0, "c8")
m.addConstr(9 * milkshakes + 10 * pickles <= 91, "c9")
m.addConstr(16 * milkshakes + 13 * pickles <= 97, "c10")

# Resource Constraints
m.addConstr(2 * oranges + 9 * milkshakes + 10 * pickles <= 127, "fat_ub")
m.addConstr(11 * oranges + 16 * milkshakes + 13 * pickles <= 129, "carb_ub")


# Non-negativity constraints are added implicitly by setting vtype to CONTINUOUS

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('oranges:', oranges.x)
    print('milkshakes:', milkshakes.x)
    print('pickles:', pickles.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

